#### Run cluster permutation statistic ####
# This function will compute if the firing of the population vector firing is significantly differnt from zero by:
# - Using the thresholded unit data from 2_filter_data as input. Config: "Units.thresholded"
# - Will run one sample t.test for all time points for each Perievent type on population vector againts zero, 
#	in order to 1) assing p.value to each time bin if signifficantly differnt, if they form a significant cluster and direction of change (Up/Down)
# - Will permute the firing sign for each unit randomly (by random multiplication by -1) and running same analysis as above. This is use to threhold by significance the identified above clusters.
# - Will run two sample t.test between two defined Event IDs, comparing as above the 1) each time bin, assigning p.value and 2) seeing if the time points form a significant cluster
# - Will permute the Event ID assignment of the above to threholds the cluster significance.
# - Perform the above analysis spliting the data on the level of Direction (if a given unit was Up/Down/Non responder) for a given Event ID

# Init --------------------------------------------------------------------
cluster_permutation_test <- function(config.file = './R/config.R'){
  tryCatch({
    
    # Load libraries
    suppressWarnings(library(tidyverse))
    suppressWarnings(library(futile.logger))
    
    suppressWarnings(library(furrr))
    plan(multiprocess) #multiprocess
    #options(future.globals.maxSize = 891289600)

    # Load config file
    source(config.file)
    source('./R/5_cluster_permutation_functions.R')

    # Set up logger
    flog.logger(name = log.name, threshold = threshold, appender = appender.tee(paste0(output.folder, log.name, ".log")))
    flog.threshold(threshold, name = log.name)
    
    flog.info(paste0("Initializing: ", format(Sys.Date(), "%d %B, %Y")), name = log.name)
    
    # Load and filter original data -------------------------------------------
    flog.info("Loading raw data", name = log.name)
    Data_original <- read_rds(path = paste0(output.folder, Units.thresholded))
    
    # prepare data for ALL treatments
    
    Filtered.data <- Data_original %>%
      unite(UnitID, File.name, SessionID, Unit) %>%
      filter(Direction %in% c("Up", "Down", "Nonresponder"))
    
    Data_original <- NULL
    
    Filtered.ids <- Filtered.data %>% select(Area.brain, TreatmentID, UnitID) %>% unique(.)
    
    # One sample t.test -----------------------------------------------------------------------------------------------
    #### one sample t.test ####
    flog.info("Calculating one sample t.test", name = log.name)
    Observed.data <- One.sample.iteration(iter = 0, Filtered.data,
                                          group_columns = one.sample.group_columns,
                                          select_columns = one.sample.select_columns, 
                                          permutation = FALSE)
    
    write_rds(Observed.data, path = paste0(output.folder, 
                                           one.sample.observed.file), "gz", compression = 9L)
    Observed.data <- NULL
    
    #### permute ####
    flog.info("Permuting one sample t.test", name = log.name)
    Iterated.merged <- future_map_dfr(iterations, 
                                      One.sample.iteration,
                                      Filtered.data,
                                      group_columns = one.sample.group_columns,
                                      select_columns = one.sample.select_columns, 
                                      permutation = TRUE)
    
    write_rds(Iterated.merged, path = paste0(output.folder, 
                                             one.sample.permuted.file), "gz", compression = 9L)
    Iterated.merged <- NULL
    
    # One sample t.test by directon ------------------------------------------------------------------------------------
    #### one sample t.test ####
    flog.info("Calculating one sample t.test by Direction", name = log.name)
    Observed.data <- One.sample.iteration(iter = 0, Filtered.data,
                                          group_columns = c(one.sample.group_columns, "Direction"),
                                          select_columns = one.sample.select_columns, 
                                          permutation = FALSE)
    
    write_rds(Observed.data, path = paste0(output.folder, "By_direction_", 
                                           one.sample.observed.file), "gz", compression = 9L)
    Observed.data <- NULL
    
    #### permute ####
    flog.info("Permuting one sample t.test by Direction", name = log.name)
    Iterated.merged <- future_map_dfr(iterations, 
                                      One.sample.iteration,
                                      Filtered.data,
                                      group_columns = c(one.sample.group_columns, "Direction"),
                                      select_columns = one.sample.select_columns, 
                                      permutation = TRUE)
    
    write_rds(Iterated.merged, path = paste0(output.folder, "By_direction_", 
                                             one.sample.permuted.file), "gz", compression = 9L)
    Iterated.merged <- NULL
    
    # # two sample t.test -----------------------------------------------------------------------------------------------
    # #### two sample t.test ####
    # List.comprisons <- list(One = c("Freezing_80_start", "Precue_Pokes"),
    #                         Two = c("Correct_Go_Sound_onset", "Correct_NG_Sound_onset"),
    #                         Three = c("Freezing_80_stop", "Precue_Pokes"),
    #                         Four = c("Correct_NG_Sound_onset", "FalseAlarm_Sound_onset"),
    #                         Five = c("Precue_Pokes", "ITI_Pokes"),
    #                         Six = c("Correct_Go_Sound_onset", "FalseAlarm_Sound_onset"),
    #                         Seven = c("Freezing_80_start", "Correct_NG_Sound_onset"))
    # 
    # for (comparison in List.comprisons) {
    #   
    #   file.temp <- paste0(comparison, collapse = "_vs_")
    #   print(file.temp)
    #   flog.info(paste0("Calculating two sample t.test: ", file.temp) , name = log.name)
    #   
    #   Observed.data <- two.sample.iteration(0, Filtered.data, 
    #                                         filter_events = comparison,
    #                                         group_columns = c("Area.brain", "TreatmentID"),
    #                                         select_columns = c("Event", "UnitID", "norm.time", "z.score"), 
    #                                         permutation = FALSE)
    #   
    #   write_rds(Observed.data, path = paste0(output.folder, 
    #                                          file.temp, two.sample.observed.file), "gz", compression = 9L)
    #   Observed.data <- NULL
    #   
    #   flog.info(paste0("Permuting two sample t.test: ", file.temp) , name = log.name)
    #   Iterated.merged <- future_map_dfr(iterations,
    #                                     two.sample.iteration,
    #                                     Filtered.data, 
    #                                     filter_events = comparison,
    #                                     group_columns = c("Area.brain", "TreatmentID"),
    #                                     select_columns = c("Event", "UnitID", "norm.time", "z.score"),
    #                                     grouping_column_permutation = c(),
    #                                     permutation = TRUE,
    #                                     .progress = TRUE)
    #   
    #   write_rds(Iterated.merged, path = paste0(output.folder, 
    #                                            file.temp, two.sample.permuted.file), "gz", compression = 9L)
    #   Iterated.merged <- NULL
    #   
    # }
    # 
    # # By direction
    # 
    # for (comparison in List.comprisons) {
    #   
    #   file.temp <- paste0(comparison, collapse = "_vs_")
    #   print(file.temp)
    #   
    #   flog.info(paste0("Calculating two sample t.test by Direction: ", file.temp) , name = log.name)
    #   Observed.data <- two.sample.iteration(0, Filtered.data, 
    #                                         filter_events = comparison,
    #                                         group_columns = c("Area.brain", "TreatmentID", "Direction"),
    #                                         select_columns = c("Event", "UnitID", "norm.time", "z.score"),
    #                                         grouping_column_permutation = c(),
    #                                         permutation = FALSE,
    #                                         paired.test = FALSE)
    #   
    #   write_rds(Observed.data, path = paste0(output.folder, "By_Direction",
    #                                          file.temp, two.sample.observed.file), "gz", compression = 9L)
    #   Observed.data <- NULL
    #   
    #   flog.info(paste0("Permuting two sample t.test by Direction: ", file.temp) , name = log.name)
    #   Iterated.merged <- future_map_dfr(iterations,
    #                                     two.sample.iteration,
    #                                     Filtered.data, 
    #                                     filter_events = comparison,
    #                                     group_columns = c("Area.brain", "TreatmentID", "Direction"),
    #                                     select_columns = c("Event", "UnitID", "norm.time", "z.score"),
    #                                     grouping_column_permutation = c(),
    #                                     permutation = TRUE,
    #                                     paired.test = FALSE)
    #   
    #   write_rds(Iterated.merged, path = paste0(output.folder, "By_Direction",
    #                                            file.temp, two.sample.permuted.file), "gz", compression = 9L)
    #   Iterated.merged <- NULL
    #   
    # }
    
    # two sample t.test for Events -------------------------------------------------------------------------------------
  
    Event.data <- Filtered.data %>% 
      rename(Temp_1 = Event, Temp_2 = TreatmentID) %>% 
      rename(Event = Temp_2, TreatmentID = Temp_1)
    
    flog.info(paste0("Calculating two sample t.test for Events") , name = log.name)
      
    Observed.data <- two.sample.iteration(0, Event.data, 
                                            filter_events = c("Vehicle", "BI_cmp"),
                                            group_columns = c("Area.brain", "TreatmentID"),
                                            select_columns = c("Event", "UnitID", "norm.time", "z.score"), 
                                            permutation = FALSE)
      
    write_rds(Observed.data, path = paste0(output.folder, 
                                           "Event_type_permutation_", two.sample.observed.file), "gz", compression = 9L)
    Observed.data <- NULL
      
    flog.info(paste0("Permuting two sample t.test for Events") , name = log.name)
    Iterated.merged <- future_map_dfr(iterations,
                                        two.sample.iteration,
                                        Event.data, 
                                        filter_events = c("Vehicle", "BI_cmp"),
                                        group_columns = c("Area.brain", "TreatmentID"),
                                        select_columns = c("Event", "UnitID", "norm.time", "z.score"),
                                        grouping_column_permutation = c(),
                                        permutation = TRUE,
                                        .progress = TRUE)
      
    write_rds(Iterated.merged, path = paste0(output.folder, 
                                             "Event_type_permutation_", two.sample.permuted.file), "gz", compression = 9L)
    Iterated.merged <- NULL

    
    flog.info(paste0("Calculating two sample t.test by Direction for Events") , name = log.name)
    Observed.data <- two.sample.iteration(0, Event.data, 
                                          filter_events = c("Vehicle", "BI_cmp"),
                                          group_columns = c("Area.brain", "TreatmentID", "Direction"),
                                          select_columns = c("Event", "UnitID", "norm.time", "z.score"),
                                          grouping_column_permutation = c(),
                                          permutation = FALSE,
                                          paired.test = FALSE)
    
    write_rds(Observed.data, path = paste0(output.folder, "By_Direction",
                                           "Event_type_permutation_", two.sample.observed.file), "gz", compression = 9L)
    Observed.data <- NULL
    
    flog.info(paste0("Permuting two sample t.test by Direction for Events") , name = log.name)
    Iterated.merged <- future_map_dfr(iterations,
                                      two.sample.iteration,
                                      Event.data, 
                                      filter_events = c("Vehicle", "BI_cmp"),
                                      group_columns = c("Area.brain", "TreatmentID", "Direction"),
                                      select_columns = c("Event", "UnitID", "norm.time", "z.score"),
                                      grouping_column_permutation = c(),
                                      permutation = TRUE,
                                      paired.test = FALSE)
    
    write_rds(Iterated.merged, path = paste0(output.folder, "By_Direction",
                                             "Event_type_permutation_", two.sample.permuted.file), "gz", compression = 9L)
    Iterated.merged <- NULL  
      
    
    return(NULL)
    
  }, error = function(e) {
    flog.error("ERROR!", name = log.name)
    flog.error(e, name = log.name)
  })
}
